def number_to_words(num):
    if not 0 <= num <= 999:
        return "عدد باید بین 0 تا 999 باشد"
    
    ones = ["صفر", "یک", "دو", "سه", "چهار", "پنج", "شش", "هفت", "هشت", "نه"]
    teens = ["ده", "یازده", "دوازده", "سیزده", "چهارده", "پانزده", "شانزده", "هفده", "هجده", "نوزده"]
    tens = ["", "", "بیست", "سی", "چهل", "پنجاه", "شصت", "هفتاد", "هشتاد", "نود"]
    hundred = "یکصد" if num >= 100 else ""
    
    if num == 0:
        return ones[0]
    
    result = ""
    
    # صدگان
    if num >= 100:
        result += ones[num // 100] + "صد"
        num %= 100
        if num > 0:
            result += " و "
    
    # اعداد 10 تا 19
    if 10 <= num <= 19:
        result += teens[num - 10]
        return result
    
    # دهگان
    if num >= 20:
        result += tens[num // 10]
        num %= 10
        if num > 0:
            result += " و "
    
    # یکان
    if 1 <= num <= 9:
        result += ones[num]
    
    return result

# تست برنامه
try:
    num = int(input("یک عدد بین 0 تا 999 وارد کنید: "))
    print(number_to_words(num))
except ValueError:
    print("لطفاً یک عدد معتبر وارد کنید")
